//=============================================================================
// MailBox, tweaked.
//=============================================================================
class MSCCraftTurnIn extends MSCCraftingDeco;

#exec TEXTURE IMPORT NAME=WeaponTurnInBox FILE=Textures\WeaponTurnInBoxFIN.PCX GROUP=Skins

var() MSCCraftingMutator Storage;

// ----------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------

function Frob(Actor F, Inventory FW)
{
	local string FrobbersIP;
	local WeaponCraftBox B;

	if ( WeaponCraftBox(DeusExPlayer(F).inHand) == None)
	{
	 Pawn(F).ClientMessage("|p4Please equip your weapon parts box first.");
	 return;
	}

	if (DeusExPlayer(F) != None && WeaponCraftBox(DeusExPlayer(F).inHand) != None)
	{
	 if (!WeaponCraftBox(DeusExPlayer(F).inHand).CheckProgress(False))
	 {
	  Pawn(F).ClientMessage("|cf88Your weapon construction has not been completed...");
	  return;
	 }
	 
	 B = WeaponCraftBox(DeusExPlayer(F).inHand);
	 PlaySound(sound'DropMediumWeapon', SLOT_Misc, 255, False, 128);

	 FrobbersIP = PlayerPawn(F).GetPlayerNetworkAddress();
	 FrobbersIP = Left(FrobbersIP, InStr(FrobbersIP, ":"));
	 //Storage.AddWeaponInfo(B.WeaponType, B.CraftMesh, B.CraftAmmo, B.FireSound, B.ReloadSound, B.FinishReloadSound, B.SelectSound, B.bSpecAcc, B.bSpecPen, B.bSpecDam, B.bSpecScope, B.bSpecSilencer, B.bSpecKnockback, B.bSpecClipSize, B.bSpecRecoil, B.bSpecRange);
         Storage.AddWeaponInfo(B.WeaponType$","$B.CraftMesh$","$B.CraftAmmo$","$B.FireSound$","$B.ReloadSound$","$B.FinishReloadSound$","$B.SelectSound$","$B.bSpecAcc$","$B.bSpecPen$","$B.bSpecDam$","$B.bSpecScope$","$B.bSpecSilencer$","$B.bSpecKnockback$","$B.bSpecClipSize$","$B.bSpecRecoil$","$B.bSpecRange, FrobbersIP);

	 Pawn(F).ClientMessage("|p4Your weapon has been turned in. You may now purchase it at any weapon store.");
	 B.Destroy();
	}
}

defaultproperties
{
     ItemName="Custom Weapon Turn-in Box"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'DeusExDeco.Mailbox'
     CollisionHeight=36.500000
     Mass=400.000000
     Buoyancy=200.000000
     bPushable=False
     bInvincible=True
     bFlammable=False
     Flammability=0.001
     Skin=Texture'WeaponTurnInBox'
     hitPoints=99999
}
